require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartWherigoWellesleyIslandSP = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartWherigoWellesleyIslandSP.MsgBoxCBFuncs = {}

zmediaSignal = Wherigo.ZMedia(cartWherigoWellesleyIslandSP)
zmediaSignal.Name="Signal"
zmediaSignal.Description=""
zmediaSignal.AltText=""
zmediaSignal.Id="179a57e5-cead-43f2-8e3e-55ba3e05077f"
zmediaSignal.Resources = {
{ Type = "jpg", Filename = "signal resize.jpg", Directives = {},},
}
zmediaCurly = Wherigo.ZMedia(cartWherigoWellesleyIslandSP)
zmediaCurly.Name="Curly"
zmediaCurly.Description=""
zmediaCurly.AltText=""
zmediaCurly.Id="7477eb29-4de0-409d-ac46-3b06c04a50e8"
zmediaCurly.Resources = {
{ Type = "jpg", Filename = "curly resize.jpg", Directives = {},},
}
zmediaMessage = Wherigo.ZMedia(cartWherigoWellesleyIslandSP)
zmediaMessage.Name="Message"
zmediaMessage.Description=""
zmediaMessage.AltText=""
zmediaMessage.Id="c5deef85-bd20-48b4-9165-3c99a7219252"
zmediaMessage.Resources = {
{ Type = "jpg", Filename = "message 2 resize.jpg", Directives = {},},
}
zmediaEinstein = Wherigo.ZMedia(cartWherigoWellesleyIslandSP)
zmediaEinstein.Name="Einstein"
zmediaEinstein.Description=""
zmediaEinstein.AltText=""
zmediaEinstein.Id="4cce47d0-6614-4ce2-a957-5f44365350e6"
zmediaEinstein.Resources = {
{ Type = "jpg", Filename = "eistien tounge resize.jpg", Directives = {},},
}
-- Cartridge Info --
cartWherigoWellesleyIslandSP.Id="9994f677-1994-4d7f-8f4c-7d50b62aa39e"
cartWherigoWellesleyIslandSP.Name="Wherigo Wellesley Island S.P."
cartWherigoWellesleyIslandSP.Description=[[A Wherigo adventure in Wellesley Island State Park. Players will need a pen or pencil and something to write on as you will be given a completeion code after the final question is answered. You will also be given the coordinates to the final at that time in case you wish to continue caching near the nature center. The first two stops and the final are some distance apart, so a vehicle is suggested. Signal is a trademark of Groundspeak Inc. and is used with permission.]]
cartWherigoWellesleyIslandSP.Visible=true
cartWherigoWellesleyIslandSP.Activity="Geocache"
cartWherigoWellesleyIslandSP.StartingLocationDescription=[[]]
cartWherigoWellesleyIslandSP.StartingLocation = ZonePoint(44.3171833356222,-76.0221833328406,0)
cartWherigoWellesleyIslandSP.Version="1.0"
cartWherigoWellesleyIslandSP.Company=""
cartWherigoWellesleyIslandSP.Author="MickEMT"
cartWherigoWellesleyIslandSP.BuilderVersion="2.0.5129.5086"
cartWherigoWellesleyIslandSP.CreateDate="10/23/2009 12:32:33 AM"
cartWherigoWellesleyIslandSP.PublishDate="1/1/0001 12:00:00 AM"
cartWherigoWellesleyIslandSP.UpdateDate="10/23/2009 7:21:08 PM"
cartWherigoWellesleyIslandSP.LastPlayedDate="1/1/0001 12:00:00 AM"
cartWherigoWellesleyIslandSP.TargetDevice="PocketPC"
cartWherigoWellesleyIslandSP.TargetDeviceVersion="0"
cartWherigoWellesleyIslandSP.StateId="1"
cartWherigoWellesleyIslandSP.CountryId="2"
cartWherigoWellesleyIslandSP.Complete=false
cartWherigoWellesleyIslandSP.UseLogging=true

-- Zones --
zoneFirstZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneFirstZone.Id="d2567cf4-fb61-45bf-ac79-4faf90bc1329"
zoneFirstZone.Name="First Zone"
zoneFirstZone.Description=[[]]
zoneFirstZone.Visible=false
zoneFirstZone.DistanceRange = Distance(1500, "feet")
zoneFirstZone.ShowObjects="OnProximity"
zoneFirstZone.ProximityRange = Distance(25, "feet")
zoneFirstZone.AllowSetPositionTo=false
zoneFirstZone.Active=false
zoneFirstZone.Points = {
  ZonePoint(44.31742,-76.02217,0),
  ZonePoint(44.31742,-76.0221,0),
  ZonePoint(44.31738,-76.0221,0),
  ZonePoint(44.31738,-76.02217,0)
}
zoneFirstZone.OriginalPoint = ZonePoint(44.3174000104268,-76.0221333324909,0)
zoneFirstZone.DistanceRangeUOM = "Feet"
zoneFirstZone.ProximityRangeUOM = "Feet"
zoneFirstZone.OutOfRangeName = ""
zoneFirstZone.InRangeName = ""

zoneSecondZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneSecondZone.Id="95e7bd11-53e3-4135-bb5f-a90bc1349e62"
zoneSecondZone.Name="Second Zone"
zoneSecondZone.Description=[[]]
zoneSecondZone.Visible=false
zoneSecondZone.DistanceRange = Distance(1.9999999984722, "miles")
zoneSecondZone.ShowObjects="OnProximity"
zoneSecondZone.ProximityRange = Distance(20, "feet")
zoneSecondZone.AllowSetPositionTo=false
zoneSecondZone.Active=false
zoneSecondZone.Points = {
  ZonePoint(44.30905,-76.03044,0),
  ZonePoint(44.30905,-76.03039,0),
  ZonePoint(44.30901,-76.03039,0),
  ZonePoint(44.30901,-76.03044,0)
}
zoneSecondZone.OriginalPoint = ZonePoint(44.3090333302816,-76.0304166674614,0)
zoneSecondZone.DistanceRangeUOM = "Miles"
zoneSecondZone.ProximityRangeUOM = "Feet"
zoneSecondZone.OutOfRangeName = ""
zoneSecondZone.InRangeName = ""

zoneThirdZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneThirdZone.Id="6e9be42c-1514-4ca1-be63-f0f90e6e6824"
zoneThirdZone.Name="Third Zone"
zoneThirdZone.Description=[[]]
zoneThirdZone.Visible=false
zoneThirdZone.DistanceRange = Distance(2, "miles")
zoneThirdZone.ShowObjects="OnProximity"
zoneThirdZone.ProximityRange = Distance(25, "feet")
zoneThirdZone.AllowSetPositionTo=false
zoneThirdZone.Active=false
zoneThirdZone.Points = {
  ZonePoint(44.30644,-76.03262,0),
  ZonePoint(44.30644,-76.03255,0),
  ZonePoint(44.30639,-76.03255,0),
  ZonePoint(44.30639,-76.03262,0)
}
zoneThirdZone.OriginalPoint = ZonePoint(44.3064166704814,-76.0325833340486,0)
zoneThirdZone.DistanceRangeUOM = "Miles"
zoneThirdZone.ProximityRangeUOM = "Feet"
zoneThirdZone.OutOfRangeName = ""
zoneThirdZone.InRangeName = ""

zoneFourthZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneFourthZone.Id="2ded0240-d1e1-45d4-8746-7ab591d78644"
zoneFourthZone.Name="Fourth Zone"
zoneFourthZone.Description=[[]]
zoneFourthZone.Visible=false
zoneFourthZone.DistanceRange = Distance(1500, "feet")
zoneFourthZone.ShowObjects="OnProximity"
zoneFourthZone.ProximityRange = Distance(25, "feet")
zoneFourthZone.AllowSetPositionTo=false
zoneFourthZone.Active=false
zoneFourthZone.Points = {
  ZonePoint(44.30659,-76.03362,0),
  ZonePoint(44.30659,-76.03355,0),
  ZonePoint(44.30654,-76.03355,0),
  ZonePoint(44.30654,-76.03362,0)
}
zoneFourthZone.OriginalPoint = ZonePoint(44.3065666516622,-76.0335833350817,0)
zoneFourthZone.DistanceRangeUOM = "Feet"
zoneFourthZone.ProximityRangeUOM = "Feet"
zoneFourthZone.OutOfRangeName = ""
zoneFourthZone.InRangeName = ""

zoneFifthZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneFifthZone.Id="d0789d86-2ccd-4ac4-a0f5-a2890dc0550a"
zoneFifthZone.Name="Fifth Zone"
zoneFifthZone.Description=[[]]
zoneFifthZone.Visible=false
zoneFifthZone.DistanceRange = Distance(1500, "feet")
zoneFifthZone.ShowObjects="OnProximity"
zoneFifthZone.ProximityRange = Distance(20, "feet")
zoneFifthZone.AllowSetPositionTo=false
zoneFifthZone.Active=false
zoneFifthZone.Points = {
  ZonePoint(44.30644,-76.03363,0),
  ZonePoint(44.30644,-76.03357,0),
  ZonePoint(44.3064,-76.03357,0),
  ZonePoint(44.3064,-76.03363,0)
}
zoneFifthZone.OriginalPoint = ZonePoint(44.3064166704814,-76.0336000005404,0)
zoneFifthZone.DistanceRangeUOM = "Feet"
zoneFifthZone.ProximityRangeUOM = "Feet"
zoneFifthZone.OutOfRangeName = ""
zoneFifthZone.InRangeName = ""

zoneSixthZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneSixthZone.Id="4fec111e-c25f-489a-85ac-7456359db656"
zoneSixthZone.Name="Sixth Zone"
zoneSixthZone.Description=[[]]
zoneSixthZone.Visible=false
zoneSixthZone.DistanceRange = Distance(1500, "feet")
zoneSixthZone.ShowObjects="OnProximity"
zoneSixthZone.ProximityRange = Distance(25, "feet")
zoneSixthZone.AllowSetPositionTo=false
zoneSixthZone.Active=false
zoneSixthZone.Points = {
  ZonePoint(44.30619,-76.0337,0),
  ZonePoint(44.30619,-76.03363,0),
  ZonePoint(44.30614,-76.03363,0),
  ZonePoint(44.30614,-76.0337,0)
}
zoneSixthZone.OriginalPoint = ZonePoint(44.3061666806539,-76.0336666663488,0)
zoneSixthZone.DistanceRangeUOM = "Feet"
zoneSixthZone.ProximityRangeUOM = "Feet"
zoneSixthZone.OutOfRangeName = ""
zoneSixthZone.InRangeName = ""

zoneSeventhZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneSeventhZone.Id="a1c43d24-60e9-4124-99a9-ee237f2cb16f"
zoneSeventhZone.Name="Seventh Zone"
zoneSeventhZone.Description=[[]]
zoneSeventhZone.Visible=false
zoneSeventhZone.DistanceRange = Distance(1500, "feet")
zoneSeventhZone.ShowObjects="OnProximity"
zoneSeventhZone.ProximityRange = Distance(25, "feet")
zoneSeventhZone.AllowSetPositionTo=false
zoneSeventhZone.Active=false
zoneSeventhZone.Points = {
  ZonePoint(44.30546,-76.03418,0),
  ZonePoint(44.30546,-76.03412,0),
  ZonePoint(44.30541,-76.03412,0),
  ZonePoint(44.30541,-76.03418,0)
}
zoneSeventhZone.OriginalPoint = ZonePoint(44.3054333368937,-76.0341500004133,0)
zoneSeventhZone.DistanceRangeUOM = "Feet"
zoneSeventhZone.ProximityRangeUOM = "Feet"
zoneSeventhZone.OutOfRangeName = ""
zoneSeventhZone.InRangeName = ""

zoneEighthZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneEighthZone.Id="ff243220-0ee8-42e3-8027-f1d71cb0647a"
zoneEighthZone.Name="Eighth Zone"
zoneEighthZone.Description=[[]]
zoneEighthZone.Visible=false
zoneEighthZone.DistanceRange = Distance(1500, "feet")
zoneEighthZone.ShowObjects="OnProximity"
zoneEighthZone.ProximityRange = Distance(25, "feet")
zoneEighthZone.AllowSetPositionTo=false
zoneEighthZone.Active=false
zoneEighthZone.Points = {
  ZonePoint(44.30631,-76.03413,0),
  ZonePoint(44.30631,-76.03407,0),
  ZonePoint(44.30626,-76.03407,0),
  ZonePoint(44.30626,-76.03413,0)
}
zoneEighthZone.OriginalPoint = ZonePoint(44.3062833468119,-76.0341000000636,0)
zoneEighthZone.DistanceRangeUOM = "Feet"
zoneEighthZone.ProximityRangeUOM = "Feet"
zoneEighthZone.OutOfRangeName = ""
zoneEighthZone.InRangeName = ""

zoneFinalZone = Wherigo.Zone(cartWherigoWellesleyIslandSP)
zoneFinalZone.Id="e26721d9-ca90-4e6f-a6e1-4ff376d15b19"
zoneFinalZone.Name="Final Zone"
zoneFinalZone.Description=[[]]
zoneFinalZone.Visible=false
zoneFinalZone.DistanceRange = Distance(2.99999999770828, "miles")
zoneFinalZone.ShowObjects="OnProximity"
zoneFinalZone.ProximityRange = Distance(20, "feet")
zoneFinalZone.AllowSetPositionTo=false
zoneFinalZone.Active=false
zoneFinalZone.Points = {
  ZonePoint(44.32014,-76.02324,0),
  ZonePoint(44.32014,-76.02319,0),
  ZonePoint(44.3201,-76.02319,0),
  ZonePoint(44.3201,-76.02324,0)
}
zoneFinalZone.OriginalPoint = ZonePoint(44.3200666745504,-76.0232166667779,0)
zoneFinalZone.DistanceRangeUOM = "Miles"
zoneFinalZone.ProximityRangeUOM = "Feet"
zoneFinalZone.OutOfRangeName = ""
zoneFinalZone.InRangeName = ""

-- Characters --
zcharacterSignal = Wherigo.ZCharacter{Cartridge=cartWherigoWellesleyIslandSP, Container=zoneFirstZone}
zcharacterSignal.Id="4e000f9e-fa75-4ab6-95b1-56ba0add9df2"
zcharacterSignal.Name="Signal"
zcharacterSignal.Description=[[]]
zcharacterSignal.Visible=false
zcharacterSignal.Media=zmediaSignal
zcharacterSignal.Gender="It"
zcharacterSignal.Type="NPC"
zcharacterSignal.ObjectLocation = ZonePoint(44.3174,-76.02214,0)
zcharacterSignal.Commands = {
  AnswerFinalQuestion = Wherigo.ZCommand{Text="Answer Final Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer2ndQuestion = Wherigo.ZCommand{Text="Answer 2nd Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer3rdQuestion = Wherigo.ZCommand{Text="Answer 3rd Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer7thQuestion = Wherigo.ZCommand{Text="Answer 7th Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer6thQuestion = Wherigo.ZCommand{Text="Answer 6th Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer4thQuestion = Wherigo.ZCommand{Text="Answer 4th Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer5thQuestion = Wherigo.ZCommand{Text="Answer 5th Question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Answer1stQuestion = Wherigo.ZCommand{Text="Answer 1st Question", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterSignal.Commands.AnswerFinalQuestion.Custom = true
zcharacterSignal.Commands.AnswerFinalQuestion.Id="b07e046b-4fae-490a-9644-0f3f03e0d0a1"
zcharacterSignal.Commands.AnswerFinalQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer2ndQuestion.Custom = true
zcharacterSignal.Commands.Answer2ndQuestion.Id="e4d56523-530a-4096-ad0c-e1e22f073aa5"
zcharacterSignal.Commands.Answer2ndQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer3rdQuestion.Custom = true
zcharacterSignal.Commands.Answer3rdQuestion.Id="9bb03b1b-9515-44fb-ad2c-65ebb463846a"
zcharacterSignal.Commands.Answer3rdQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer7thQuestion.Custom = true
zcharacterSignal.Commands.Answer7thQuestion.Id="54ac5869-e789-4950-99e4-1343e501f9ad"
zcharacterSignal.Commands.Answer7thQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer6thQuestion.Custom = true
zcharacterSignal.Commands.Answer6thQuestion.Id="d6dab513-a3ca-4b95-9a50-2d9a90e48d30"
zcharacterSignal.Commands.Answer6thQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer4thQuestion.Custom = true
zcharacterSignal.Commands.Answer4thQuestion.Id="70be1aaf-2c7d-4e74-87ba-675664bf6c9b"
zcharacterSignal.Commands.Answer4thQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer5thQuestion.Custom = true
zcharacterSignal.Commands.Answer5thQuestion.Id="42a43b8e-6e42-4e17-9abc-672d2ff775a1"
zcharacterSignal.Commands.Answer5thQuestion.WorksWithAll = true
zcharacterSignal.Commands.Answer1stQuestion.Custom = true
zcharacterSignal.Commands.Answer1stQuestion.Id="54098149-671b-4fd1-bdc8-b7fb1f25dd98"
zcharacterSignal.Commands.Answer1stQuestion.WorksWithAll = true

-- Items --

-- Tasks --
ztaskAnswerAllquestions = Wherigo.ZTask(cartWherigoWellesleyIslandSP)
ztaskAnswerAllquestions.Id="4aff56de-5786-4f6e-9e3f-28b8ea7649b4"
ztaskAnswerAllquestions.Name="Answer All questions"
ztaskAnswerAllquestions.Description=[[]]
ztaskAnswerAllquestions.Visible=false
ztaskAnswerAllquestions.Active=true
ztaskAnswerAllquestions.Complete=false
ztaskAnswerAllquestions.CorrectState = "None"

-- Cartridge Variables --
EighthVariable = 0
SecondVariable = ""
ThirdVariable = 0
FourthVariable = ""
FifthVariable = ""
FirstVariable = 0
SeventhVariable = ""
SixthVariable = 0
cartWherigoWellesleyIslandSP.ZVariables = {EighthVariable = 0, SecondVariable = "", ThirdVariable = 0, FourthVariable = "", FifthVariable = "", FirstVariable = 0, SeventhVariable = "", SixthVariable = 0}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.EighthVariable = {}
buildervar.EighthVariable.Id ="e37c8cbb-7099-404d-a6be-55fd97300f28"
buildervar.EighthVariable.Name = "Eighth Variable"
buildervar.EighthVariable.Type = "Number"
buildervar.EighthVariable.Data=[[0]]
buildervar.EighthVariable.Description=[[]]

buildervar.SecondVariable = {}
buildervar.SecondVariable.Id ="573a79a1-d595-46fe-a998-f97ae954796c"
buildervar.SecondVariable.Name = "Second Variable"
buildervar.SecondVariable.Type = "String"
buildervar.SecondVariable.Data=[[]]
buildervar.SecondVariable.Description=[[]]

buildervar.ThirdVariable = {}
buildervar.ThirdVariable.Id ="c7c98602-cb3c-4001-ac9d-c781a59ddf71"
buildervar.ThirdVariable.Name = "Third Variable"
buildervar.ThirdVariable.Type = "Number"
buildervar.ThirdVariable.Data=[[0]]
buildervar.ThirdVariable.Description=[[]]

buildervar.FourthVariable = {}
buildervar.FourthVariable.Id ="b0a0d494-60c7-4016-9b81-690ab0fa5fdc"
buildervar.FourthVariable.Name = "Fourth Variable"
buildervar.FourthVariable.Type = "String"
buildervar.FourthVariable.Data=[[]]
buildervar.FourthVariable.Description=[[]]

buildervar.FifthVariable = {}
buildervar.FifthVariable.Id ="8442f8d0-1a81-4832-bc65-d0f8965a5963"
buildervar.FifthVariable.Name = "Fifth Variable"
buildervar.FifthVariable.Type = "String"
buildervar.FifthVariable.Data=[[]]
buildervar.FifthVariable.Description=[[]]

buildervar.FirstVariable = {}
buildervar.FirstVariable.Id ="af962359-0b50-4775-a94a-e58466c3c3df"
buildervar.FirstVariable.Name = "First Variable"
buildervar.FirstVariable.Type = "Number"
buildervar.FirstVariable.Data=[[0]]
buildervar.FirstVariable.Description=[[]]

buildervar.SeventhVariable = {}
buildervar.SeventhVariable.Id ="5b9ab4d6-13d9-4bac-bb35-c11b07f0c837"
buildervar.SeventhVariable.Name = "Seventh Variable"
buildervar.SeventhVariable.Type = "String"
buildervar.SeventhVariable.Data=[[]]
buildervar.SeventhVariable.Description=[[]]

buildervar.SixthVariable = {}
buildervar.SixthVariable.Id ="85454e8c-2683-47c2-948b-2bfde039686a"
buildervar.SixthVariable.Name = "Sixth Variable"
buildervar.SixthVariable.Type = "Number"
buildervar.SixthVariable.Data=[[0]]
buildervar.SixthVariable.Description=[[]]


-- ZTimers --

-- Inputs --
zinputFirstInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputFirstInput.Id="63c94620-9268-44d5-8441-4687adc4a526"
zinputFirstInput.Name="First Input"
zinputFirstInput.Description=[[]]
zinputFirstInput.Visible=true
zinputFirstInput.InputType="Text"
zinputFirstInput.InputVariableId="af962359-0b50-4775-a94a-e58466c3c3df"
zinputFirstInput.Text=[[How many feet is the wingspan of an Osprey?]]
zinputFirstInput.Media=zmediaSignal

zinputSecondInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputSecondInput.Id="4035e295-31a9-42dd-8ae2-0f2664d640c4"
zinputSecondInput.Name="Second Input"
zinputSecondInput.Description=[[]]
zinputSecondInput.Visible=true
zinputSecondInput.InputType="Text"
zinputSecondInput.InputVariableId="573a79a1-d595-46fe-a998-f97ae954796c"
zinputSecondInput.Text=[[Is the first chick hatch the strongest or weakest?]]
zinputSecondInput.Media=zmediaSignal

zinputThirdInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputThirdInput.Id="fd06acb0-b6ab-4c07-b3f4-f4f6c8537a80"
zinputThirdInput.Name="Third Input"
zinputThirdInput.Description=[[]]
zinputThirdInput.Visible=true
zinputThirdInput.InputType="Text"
zinputThirdInput.InputVariableId="c7c98602-cb3c-4001-ac9d-c781a59ddf71"
zinputThirdInput.Text=[[In what year was the Nature Center established?]]
zinputThirdInput.Media=zmediaSignal

zinputFourthInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputFourthInput.Id="0118a15f-d7ab-4c9e-aa96-5e64a776a335"
zinputFourthInput.Name="Fourth Input"
zinputFourthInput.Description=[[]]
zinputFourthInput.Visible=true
zinputFourthInput.InputType="Text"
zinputFourthInput.InputVariableId="b0a0d494-60c7-4016-9b81-690ab0fa5fdc"
zinputFourthInput.Text=[[Eel Bay is between Wellesley and WHAT islands?]]
zinputFourthInput.Media=zmediaSignal

zinputFifthInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputFifthInput.Id="0658b5a4-3dcd-4b36-8095-51d0d22eb985"
zinputFifthInput.Name="Fifth Input"
zinputFifthInput.Description=[[]]
zinputFifthInput.Visible=true
zinputFifthInput.InputType="Text"
zinputFifthInput.InputVariableId="8442f8d0-1a81-4832-bc65-d0f8965a5963"
zinputFifthInput.Text=[[Chlorite and Hexagonite are two types of WHAT serpentines?]]
zinputFifthInput.Media=zmediaSignal

zinputSixthinput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputSixthinput.Id="66d68641-a1df-4238-8144-0bdfb8394efb"
zinputSixthinput.Name="Sixth input"
zinputSixthinput.Description=[[]]
zinputSixthinput.Visible=true
zinputSixthinput.InputType="Text"
zinputSixthinput.InputVariableId="85454e8c-2683-47c2-948b-2bfde039686a"
zinputSixthinput.Text=[[The Bald Eagel has a wingspan of HOW MANY inches?]]
zinputSixthinput.Media=zmediaSignal

zinputSeventhInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputSeventhInput.Id="1fdcb797-eab1-4063-9219-ddd96886112a"
zinputSeventhInput.Name="Seventh Input"
zinputSeventhInput.Description=[[]]
zinputSeventhInput.Visible=true
zinputSeventhInput.InputType="Text"
zinputSeventhInput.InputVariableId="5b9ab4d6-13d9-4bac-bb35-c11b07f0c837"
zinputSeventhInput.Text=[[There is a small blue sign nearby with Chipmunks and WHAT ANIMAL on it]]
zinputSeventhInput.Media=zmediaSignal

zinputEighthInput = Wherigo.ZInput(cartWherigoWellesleyIslandSP)
zinputEighthInput.Id="51bc63aa-63f6-48f6-885e-26b6de1430b4"
zinputEighthInput.Name="Eighth Input"
zinputEighthInput.Description=[[]]
zinputEighthInput.Visible=true
zinputEighthInput.InputType="Text"
zinputEighthInput.InputVariableId="e37c8cbb-7099-404d-a6be-55fd97300f28"
zinputEighthInput.Text=[[How many years ago were the glaciers melting?]]
zinputEighthInput.Media=zmediaSignal

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function cartWherigoWellesleyIslandSP:OnStart()
-- #GroupDescription=Cart Start --
-- #Comment=Cart Start Comment --
zoneFirstZone.Active = true
zoneFirstZone.Visible = true
Wherigo.MessageBox{Text=[[Welcome to the Wherigo Wellesley Island State Park cartridge. During the adventure, you will be directed to eight stops. At each stop your tour guide, Signal, will have a question that you must answer correctly to continue. When you have answered all of his questions, he will give you a completion code that you will need to write down and enter on the cartridge page to ulock the cartridge and mark it as complete. He will then make the zone with the actual cache visible and show you a message with the cache coordinates. Click OK when you are ready to begin and head over to the first stop. When you get there, talk to Signal.]],}
end

function zoneFirstZone:OnProximity()
-- #GroupDescription=zone 1 prox --
-- #Comment=zone 1 prox Comment --
zcharacterSignal.Visible = true
Wherigo.MessageBox{Text=[[Hi, I'm your tour guide, Signal. As we go along, I'll have a question for you at each stop. Read the question, then, when you have the answer, click on me again. If you are right, I'll make the next stop visible on your screen. I not, click on me for another chance to answer the question. Click OK when you are ready for your first question.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB1}
end

function zinputFirstInput:OnGetInput(input)
FirstVariable = tonumber(input)
-- #GroupDescription=First answer --
-- #Comment=First answer Comment --
if   FirstVariable == 5 then
zoneSecondZone.Active = true
zoneSecondZone.Visible = true
Wherigo.MessageBox{Text=[[Great work! Thanks to the end of the use of DDT as a pesticide, Osprey populations are increasing again. The second zone is on the road leading to the nature center, I'll meet you there.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB2}
elseif FirstVariable ~= 5 then
Wherigo.MessageBox{Text=[[Whoops! Check the sign again!]],Media=zmediaCurly,}
end
end

function zoneSecondZone:OnProximity()
-- #GroupDescription=zone 2 prox --
-- #Comment=zone 2 prox Comment --
zcharacterSignal.Commands["Answer2ndQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[OK, you made it. Your second question is about the Osprey. Click OK when you are ready for it.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB3}
end

function zinputSecondInput:OnGetInput(input)
SecondVariable = input
-- #GroupDescription=second answer --
-- #Comment=second answer Comment --
if   Wherigo.NoCaseEquals(SecondVariable,"Strongest") then
zoneThirdZone.Active = true
zoneThirdZone.Visible = true
Wherigo.MessageBox{Text=[[Great Job! Now head on down to the nature center. The rest of our stops are near that.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB4}
elseif not Wherigo.NoCaseEquals(SecondVariable,"Strongest") then
Wherigo.MessageBox{Text=[[ Nope,better read that sign again!]],Media=zmediaEinstein,}
end
end

function zoneThirdZone:OnProximity()
-- #GroupDescription=zone 3 prox --
-- #Comment=zone 3 prox Comment --
zcharacterSignal.Commands["Answer3rdQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[Welcome to the Minna Anthony Nature Center. The rest of our stops are around the center or on the nearby trails. Don't worry, the terrain isn't too bad. Ready for your next question? Click OK.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB5}
end

function zinputThirdInput:OnGetInput(input)
ThirdVariable = tonumber(input)
-- #GroupDescription=third input --
-- #Comment=third input Comment --
if   ThirdVariable == 1969 then
zoneFourthZone.Active = true
zoneFourthZone.Visible = true
Wherigo.MessageBox{Text=[[That's right. this is a 600 acre nature preserve with a museum, hiking and skiing trails and educational programs. Your next stop is behind the nature center building.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB6}
elseif ThirdVariable ~= 1969 then
Wherigo.MessageBox{Text=[[Whoops! Try Again!]],Media=zmediaCurly,}
end
end

function zoneFourthZone:OnProximity()
-- #GroupDescription=zone 4 prox --
-- #Comment=zone 4 prox Comment --
zcharacterSignal.Commands["Answer4thQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[OK, just about halfway done. Your next question is about Eel Bay, click OK when you are ready for it.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB7}
end

function zinputFourthInput:OnGetInput(input)
FourthVariable = input
-- #GroupDescription=q 4 answer --
-- #Comment=q 4 answer Comment --
if   Wherigo.NoCaseEquals(FourthVariable,"Grindstone") then
zoneFifthZone.Active = true
zoneFifthZone.Visible = true
Wherigo.MessageBox{Text=[[Exactly right! Now head on over to the geology wall for your next question.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB8}
elseif not Wherigo.NoCaseEquals(FourthVariable,"Grindstone") then
Wherigo.MessageBox{Text=[[Being wrong is such a GRIND! Hmm, was that a hint Moe?]],Media=zmediaCurly,}
end
end

function zoneFifthZone:OnProximity()
-- #GroupDescription=zone 5 prox --
-- #Comment=zone 5 prox Comment --
zcharacterSignal.Commands["Answer5thQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[Ok, my friend Geodiving LOVES geology, so of course I have to include that. Click Ok when you are ready for the next question.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB9}
end

function zinputFifthInput:OnGetInput(input)
FifthVariable = input
-- #GroupDescription=q 5 answer --
-- #Comment=q 5 answer Comment --
if   Wherigo.NoCaseEquals(FifthVariable,"Mixed") then
zoneSixthZone.Active = true
zoneSixthZone.Visible = true
Wherigo.MessageBox{Text=[[Right again! Now head on over to your next zone. ]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB10}
elseif not Wherigo.NoCaseEquals(FifthVariable,"Mixed") then
Wherigo.MessageBox{Text=[[Hmm, better check the wall again, I think you got MIXED up!]],Media=zmediaEinstein,}
end
end

function zoneSixthZone:OnProximity()
-- #GroupDescription=zone 6 prox --
-- #Comment=zone 6 prox Comment --
zcharacterSignal.Commands["Answer6thQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[You are doing great so far, only two stops after this one. Clcik Ok for your next question.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB11}
end

function zinputSixthinput:OnGetInput(input)
SixthVariable = tonumber(input)
-- #GroupDescription=q 6 answer --
-- #Comment=q 6 answer Comment --
if   SixthVariable == 84 then
zoneSeventhZone.Active = true
zoneSeventhZone.Visible = true
Wherigo.MessageBox{Text=[[Right! The Bald Eagle has up to a 7 foot wingspan, how big is yours? Now head on off to the next stop.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB12}
elseif SixthVariable ~= 84 then
Wherigo.MessageBox{Text=[[Better check the sign again!!! ]],Media=zmediaCurly,}
end
end

function zoneSeventhZone:OnProximity()
-- #GroupDescription=zone 7 prox --
-- #Comment=zone 7 prox Comment --
zcharacterSignal.Commands["Answer7thQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[OK, look around for a blue sign, it holds the answer to your next question. Click OK to continue.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB13}
end

function zinputSeventhInput:OnGetInput(input)
SeventhVariable = input
-- #GroupDescription=q 7 answer --
-- #Comment=q 7 answer Comment --
if   Wherigo.NoCaseEquals(SeventhVariable,"Squirrels") then
zoneEighthZone.Active = true
zoneEighthZone.Visible = true
Wherigo.MessageBox{Text=[[Right again! Only one more stop before the cache! Click Ok and I'll meet you there.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB14}
elseif not Wherigo.NoCaseEquals(SeventhVariable,"Squirrels") then
Wherigo.MessageBox{Text=[[I'll give you a hint, they hide nuts and live in trees.]],Media=zmediaEinstein,}
end
end

function zoneEighthZone:OnProximity()
-- #GroupDescription=zone 8 prox --
-- #Comment=zone 8 prox Comment --
zcharacterSignal.Commands["AnswerFinalQuestion"].Enabled = true
Wherigo.MessageBox{Text=[[Ok, this is the final stop before the cache. When you anser this one correctly, you will be given a completion code to enter on the cartridge page at wherigo.com, make sure you write it down! Click OK for your final question.]],Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB15}
end

function zinputEighthInput:OnGetInput(input)
EighthVariable = tonumber(input)
-- #GroupDescription=q 8 answer --
-- #Comment=q 8 answer Comment --
if   EighthVariable == 9000 then
ztaskAnswerAllquestions.Complete = true
cartWherigoWellesleyIslandSP.Complete = true
cartWherigoWellesleyIslandSP:RequestSync()
zoneFinalZone.Active = true
zoneFinalZone.Visible = true
Wherigo.MessageBox{Text=[[That's Right! Well, our tour is finished, I hope you enjoyed it. Make sure to write down the completion code. Once you have done that, click OK and I'll set the cache zone visible, and show you a message with the coordinates. Your completion Code is : ]] .. Player.CompletionCode ,Media=zmediaSignal,Callback=cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB16}
elseif EighthVariable ~= 9000 then
Wherigo.MessageBox{Text=[[Hmm, you made it this far, you deserve a hint. Your number of fingers, minus one, then multiplied by one thousand.]],Media=zmediaEinstein,}
end
end

function zcharacterSignal:OnAnswer1stQuestion()
-- #GroupDescription=tts1 --
-- #Comment=tts1 Comment --
Wherigo.GetInput(zinputFirstInput)
end

function zcharacterSignal:OnAnswer2ndQuestion()
-- #GroupDescription=tts2 --
-- #Comment=tts2 Comment --
Wherigo.GetInput(zinputSecondInput)
end

function zcharacterSignal:OnAnswer3rdQuestion()
-- #GroupDescription=tts3 --
-- #Comment=tts3 Comment --
Wherigo.GetInput(zinputThirdInput)
end

function zcharacterSignal:OnAnswer4thQuestion()
-- #GroupDescription=tts4 --
-- #Comment=tts4 Comment --
Wherigo.GetInput(zinputFourthInput)
end

function zcharacterSignal:OnAnswer5thQuestion()
-- #GroupDescription=tts5 --
-- #Comment=tts5 Comment --
Wherigo.GetInput(zinputFifthInput)
end

function zcharacterSignal:OnAnswer6thQuestion()
-- #GroupDescription=tts6 --
-- #Comment=tts6 Comment --
Wherigo.GetInput(zinputSixthinput)
end

function zcharacterSignal:OnAnswer7thQuestion()
-- #GroupDescription=tts7 --
-- #Comment=tts7 Comment --
Wherigo.GetInput(zinputSeventhInput)
end

function zcharacterSignal:OnAnswerFinalQuestion()
-- #GroupDescription=tts8 --
-- #Comment=tts8 Comment --
Wherigo.GetInput(zinputEighthInput)
end

function zoneFinalZone:OnProximity()
-- #GroupDescription=final prox --
-- #Comment=final prox Comment --
Wherigo.MessageBox{Text=[[OK, you made it to the cache area. Good hunting! You can turn off  the cartridge at any time.]],Media=zmediaSignal,}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=16#--
cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=first ans corect --
-- #Comment=first ans corect Comment --
zoneFirstZone.Active = false
zoneFirstZone.Visible = false
zcharacterSignal.Commands["Answer1stQuestion"].Enabled = false
zcharacterSignal.Commands["Answer2ndQuestion"].Enabled = true
zcharacterSignal:MoveTo(zoneSecondZone)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=zone 2 q --
-- #Comment=zone 2 q Comment --
Wherigo.GetInput(zinputSecondInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
if action ~= nil then
-- #GroupDescription=second q correct --
-- #Comment=second q correct Comment --
zoneSecondZone.Active = false
zoneSecondZone.Visible = false
zcharacterSignal:MoveTo(zoneThirdZone)
zcharacterSignal.Commands["Answer2ndQuestion"].Enabled = false
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
if action ~= nil then
-- #GroupDescription=third zone q --
-- #Comment=third zone q Comment --
Wherigo.GetInput(zinputThirdInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
if action ~= nil then
-- #GroupDescription=q3 correct --
-- #Comment=q3 correct Comment --
zoneThirdZone.Active = false
zoneThirdZone.Visible = false
zcharacterSignal.Commands["Answer3rdQuestion"].Enabled = false
zcharacterSignal:MoveTo(zoneFourthZone)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=first zone Q --
-- #Comment=first zone Q Comment --
Wherigo.GetInput(zinputFirstInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
if action ~= nil then
-- #GroupDescription=q4 answer --
-- #Comment=q4 answer Comment --
Wherigo.GetInput(zinputFourthInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
if action ~= nil then
-- #GroupDescription=q4 right --
-- #Comment=q4 right Comment --
zoneFourthZone.Active = false
zoneFourthZone.Visible = false
zcharacterSignal.Commands["Answer4thQuestion"].Enabled = false
zcharacterSignal:MoveTo(zoneFifthZone)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
if action ~= nil then
-- #GroupDescription=q 5 asked --
-- #Comment=q 5 asked Comment --
Wherigo.GetInput(zinputFifthInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
if action ~= nil then
-- #GroupDescription=q 5 right --
-- #Comment=q 5 right Comment --
zoneFifthZone.Active = false
zoneFifthZone.Visible = false
zcharacterSignal.Commands["Answer5thQuestion"].Enabled = false
zcharacterSignal:MoveTo(zoneSixthZone)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
if action ~= nil then
-- #GroupDescription=q 6 ask --
-- #Comment=q 6 ask Comment --
Wherigo.GetInput(zinputSixthinput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
if action ~= nil then
-- #GroupDescription=q 6 right --
-- #Comment=q 6 right Comment --
zoneSixthZone.Active = false
zoneSixthZone.Visible = false
zcharacterSignal.Commands["Answer6thQuestion"].Enabled = false
zcharacterSignal:MoveTo(zoneSeventhZone)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
if action ~= nil then
-- #GroupDescription=q7 ask --
-- #Comment=q7 ask Comment --
Wherigo.GetInput(zinputSeventhInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB15 = function(action)
if action ~= nil then
-- #GroupDescription=q8 ask --
-- #Comment=q8 ask Comment --
Wherigo.GetInput(zinputEighthInput)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB14 = function(action)
if action ~= nil then
-- #GroupDescription=q 7 right --
-- #Comment=q 7 right Comment --
zoneSeventhZone.Active = false
zoneSeventhZone.Visible = false
zcharacterSignal.Commands["Answer7thQuestion"].Enabled = false
zcharacterSignal:MoveTo(zoneEighthZone)
end
end

cartWherigoWellesleyIslandSP.MsgBoxCBFuncs.MsgBoxCB16 = function(action)
if action ~= nil then
-- #GroupDescription=show coords --
-- #Comment=show coords Comment --
cartWherigoWellesleyIslandSP:RequestSync()
zoneEighthZone.Active = false
zoneEighthZone.Visible = false
Wherigo.MessageBox{Text=[[You can write down the coords if you want to stay in the area for a while, the cache is near the area of the first stop.]],Media=zmediaMessage,}
end
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartWherigoWellesleyIslandSP
